/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1;

import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.BEROctetStringParser;
import cn.com.infosec.asn1.BERSequenceParser;
import cn.com.infosec.asn1.BERSetParser;
import cn.com.infosec.asn1.BERTaggedObjectParser;
import cn.com.infosec.asn1.DERApplicationSpecific;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DEROctetStringParser;
import cn.com.infosec.asn1.DERSequenceParser;
import cn.com.infosec.asn1.DERSetParser;
import cn.com.infosec.asn1.DERUnknownTag;
import cn.com.infosec.asn1.DefiniteLengthInputStream;
import cn.com.infosec.asn1.IndefiniteLengthInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1StreamParser {
    private final InputStream _in;
    private final int _limit;

    public ASN1StreamParser(InputStream in) {
        this(in, Integer.MAX_VALUE);
    }

    public ASN1StreamParser(InputStream in, int limit) {
        this._in = in;
        this._limit = limit;
    }

    public ASN1StreamParser(byte[] encoding) {
        this(new ByteArrayInputStream(encoding), encoding.length);
    }

    public DEREncodable readObject() throws IOException {
        int tag = this._in.read();
        if (tag == -1) {
            return null;
        }
        this.set00Check(false);
        int tagNo = 0;
        if ((tag & 0x80) != 0 || (tag & 0x40) != 0) {
            tagNo = ASN1InputStream.readTagNumber(this._in, tag);
        }
        boolean isConstructed = (tag & 0x20) != 0;
        int baseTagNo = tag & 0xFFFFFFDF;
        int length = ASN1InputStream.readLength(this._in, this._limit);
        if (length < 0) {
            if (!isConstructed) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indIn = new IndefiniteLengthInputStream(this._in);
            if ((tag & 0x80) != 0) {
                return new BERTaggedObjectParser(tag, tagNo, indIn);
            }
            ASN1StreamParser sp = new ASN1StreamParser(indIn);
            switch (baseTagNo) {
                case 4: {
                    return new BEROctetStringParser(sp);
                }
                case 16: {
                    return new BERSequenceParser(sp);
                }
                case 17: {
                    return new BERSetParser(sp);
                }
            }
            throw new IOException("unknown BER object encountered");
        }
        DefiniteLengthInputStream defIn = new DefiniteLengthInputStream(this._in, length);
        if ((tag & 0x40) != 0) {
            return new DERApplicationSpecific(isConstructed, tagNo, defIn.toByteArray());
        }
        if ((tag & 0x80) != 0) {
            return new BERTaggedObjectParser(tag, tagNo, defIn);
        }
        if (isConstructed) {
            switch (baseTagNo) {
                case 4: {
                    return new BEROctetStringParser(new ASN1StreamParser(defIn));
                }
                case 16: {
                    return new DERSequenceParser(new ASN1StreamParser(defIn));
                }
                case 17: {
                    return new DERSetParser(new ASN1StreamParser(defIn));
                }
            }
            return new DERUnknownTag(tag, defIn.toByteArray());
        }
        switch (baseTagNo) {
            case 4: {
                return new DEROctetStringParser(defIn);
            }
        }
        return ASN1InputStream.createPrimitiveDERObject(tag, defIn.toByteArray());
    }

    private void set00Check(boolean enabled) {
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(enabled);
        }
    }

    ASN1EncodableVector readVector() throws IOException {
        DEREncodable obj;
        ASN1EncodableVector v = new ASN1EncodableVector();
        while ((obj = this.readObject()) != null) {
            v.add(obj.getDERObject());
        }
        return v;
    }
}

