package com.clx.performance.vo.pc;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.apache.poi.hpsf.Decimal;

import java.math.BigDecimal;
import java.time.LocalDateTime;


@Getter
@Setter
@NoArgsConstructor
public class OwnerAccountVO {

    @ApiModelProperty(value = "id")
    private Integer id;
    /**
     * 货主编码
     */
    @ApiModelProperty(value = "货主编码")
    private String ownerUserNo;
    /**
     * 货主名称
     */
    @ApiModelProperty(value = "货主名称")
    private String ownerUserName;
    /**
     * 联系电话
     */
    @ApiModelProperty(value = "联系电话")
    private String mobile;
    /**
     * 账户类型;1:保证金 2：预付运费
     */
    @ApiModelProperty(value = "账户类型;1:保证金 2：预付运费")
    private Integer accountType;
    /**
     * 账户余额
     */
    @ApiModelProperty(value = "账户余额")
    @MoneyOutConvert
    private BigDecimal accountBalance;
    /**
     * 可用余额
     */
    @ApiModelProperty(value = "可用余额")
    @MoneyOutConvert
    private BigDecimal usableBalance;
    /**
     * 冻结金额
     */
    @ApiModelProperty(value = "冻结金额")
    @MoneyOutConvert
    private BigDecimal frozenBalance;

    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createBy;
    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private String createTime;

    @ApiModelProperty(value = "修改时间")
    private String modifiedTime;

}