package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public enum OrderEnum {
    ;

    //订单状态： 0待报价 1客户确认中 2报价已确认 3平台已承接 4已取消 5暂停 6拒绝承运 7 挂单中 8运输中 9订单已完成 10 已失效
    @Getter
    @AllArgsConstructor
    public enum Status {
        WAIT_QUOTATION(0, "待报价"),
        CUSTOMER_CONFIRMING(1, "客户确认中"),
        QUOTATION_CONFIRMED(2, "报价已确认"),
        PLATFORM_UNDERTAKING(3, "平台已承接"),
        CANCELED(4, "已取消"),
        SUSPEND(5, "暂停"),
        REFUSAL_TO_CARRY(6, "拒绝承运"),
        ON_ORDER(7, "挂单中"),
        IN_TRANSIT(8, "运输中"),
        SUCCESS(9, "订单已完成"),
        EXPIRED(10, "已失效"),
        POST_ORDER(11, "已挂单"),
        COMPLETED(12,"已完结")

        ;
        private final Integer code;
        private final String name;
        public static Status getByCode(int code) {
            for(Status type: Status.values()){
                if(type.code == code){
                    return type;
                }
            }
            return null;
        }
    }


    //申请状态 1.申请  2.驳回 3.同意  4.过期'
    @Getter
    @AllArgsConstructor
    public enum CancelApplyStatus {
        APPLY(1, "申请"),
        REJECT(2, "驳回"),
        AGREE(3, "同意"),
        EXPIRED(4, "过期");
        private final int code;
        private final String name;
        public static Status getByCode(int code) {
            for(Status type: Status.values()){
                if(type.code == code){
                    return type;
                }
            }
            return null;
        }
    }

    //报价状态 2.确认报价 3.驳回报价  4.报价过期'
    @Getter
    @AllArgsConstructor
    public enum QuotationStatus{
        CONFIRM(2, "确认报价"),
        REJECT(3, "驳回报价"),
        EXPIRE(4, "报价过期");
        private final int code;
        private final String name;
        public static QuotationStatus getByCode(Integer code) {
            for(QuotationStatus type: QuotationStatus.values()){
                if(type.code == code){
                    return type;
                }
            }
            return null;
        }
    }

    @Getter
    @AllArgsConstructor
    public enum OverWeight{
        NO(0, "否"),
        YES(1, "是");
        private final Integer code;
        private final String name;
        public static OverWeight getByCode(Integer code) {
            for(OverWeight type: OverWeight.values()){
                if(Objects.equals(type.code,code)){
                    return type;
                }
            }
            return null;
        }
    }



    @Getter
    @AllArgsConstructor
    public enum ReportFlag{
        NO(0, "否"),
        YES(1, "是");
        private final int code;
        private final String name;
        public static String getNameByCode(int code) {
            for(ReportFlag type: ReportFlag.values()){
                if(type.code == code){
                    return type.getName();
                }
            }
            return null;
        }
    }




    //预付运费标识  1:部分预付 2：全额预付
    @Getter
    @AllArgsConstructor
    public enum PrepayFreightFlag{
        PART(1, "部分预付"),
        ALL(2, "全额预付");
        private final Integer code;
        private final String name;
        public static String getByCode(Integer code) {
            for(PrepayFreightFlag type: PrepayFreightFlag.values()){
                if(Objects.equals(type.code,code)){
                    return type.getName();
                }
            }
            return null;
        }
    }



    public static final List<Integer> BORROW_TIP_STATUS_lIST = Arrays.asList(
            Status.PLATFORM_UNDERTAKING.getCode(),
            Status.ON_ORDER.getCode(),
            Status.POST_ORDER.getCode(),
            Status.IN_TRANSIT.getCode()

    );
    //外部系统可以修改数据的状态
    public static final List<Integer> SYNC_ORDER_UPDATE_lIST = Arrays.asList(
            Status.CUSTOMER_CONFIRMING.getCode(),
            Status.QUOTATION_CONFIRMED.getCode(),
            Status.PLATFORM_UNDERTAKING.getCode(),
            Status.ON_ORDER.getCode(),
            Status.POST_ORDER.getCode(),
            Status.IN_TRANSIT.getCode()

    );

}
