/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.util;

import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class NSRandom
extends Random {
    private static final long serialVersionUID = 3609667680271768782L;
    private static SecureRandom sRan = new SecureRandom();
    private static int bufsize = 0x200000;
    private static int ranBlockSize = 16;
    private static byte[] ranbuf = new byte[bufsize];
    private static AtomicInteger ranPos = new AtomicInteger(0);
    private static boolean needRestBuff = false;
    private static Thread randomReseter;

    private static synchronized byte nextByteFromBuffer() {
        int pos = ranPos.getAndAdd(1);
        if (pos >= bufsize) {
            ranPos.set(0);
            pos = 0;
        }
        if (pos == bufsize / 2) {
            needRestBuff = true;
        }
        return ranbuf[pos];
    }

    public void nextBytes(byte[] ran) {
        super.nextBytes(ran);
        byte r = NSRandom.nextByteFromBuffer();
        int i = 0;
        while (i < ran.length) {
            int n = i;
            ran[n] = (byte)(ran[n] ^ r);
            if ((i + 1) % ranBlockSize == 0 && i + 1 < ran.length) {
                r = NSRandom.nextByteFromBuffer();
            }
            ++i;
        }
    }

    public int nextInt() {
        int i = super.nextInt();
        byte[] bs = CryptoUtil.int2Bytes(i);
        byte r = NSRandom.nextByteFromBuffer();
        int j = 0;
        while (j < bs.length) {
            int n = j++;
            bs[n] = (byte)(bs[n] ^ r);
        }
        return CryptoUtil.generateInt(bs);
    }

    public NSRandom() {
        this.startGenerator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startGenerator() {
        SecureRandom secureRandom = sRan;
        synchronized (secureRandom) {
            if (randomReseter == null) {
                sRan.nextBytes(ranbuf);
                randomReseter = new Thread(new RandomBufferRester());
                randomReseter.setName("Random Number Generator");
                randomReseter.start();
                System.out.println("Start random generator");
            }
        }
    }

    public static void main(String[] args) {
        byte[] key = new byte[16];
        new NSRandom().nextBytes(key);
        System.out.println(Arrays.toString(key));
        String DESKey = Base64.encode(key);
        System.out.println("base64\u540e\u7ed3\u679c\uff1a" + DESKey);
        byte[] s = new byte[24];
        System.arraycopy(key, 0, s, 0, 16);
        System.arraycopy(key, 0, s, 16, 8);
        System.out.println(Arrays.toString(s));
    }

    private class RandomBufferRester
    implements Runnable {
        private RandomBufferRester() {
        }

        public void run() {
            while (true) {
                if (needRestBuff) {
                    byte[] tmpr = new byte[bufsize];
                    sRan.nextBytes(tmpr);
                    ranbuf = tmpr;
                    needRestBuff = false;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

