package com.clx.performance.service.impl.settle;

import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.service.broker.OrderChildBrokerMqService;
import com.clx.performance.service.settle.SettlementMqService;
import com.clx.performance.service.settle.SettlementPostService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class SettlementPostServiceImpl implements SettlementPostService {

    @Autowired
    private SettlementMqService settlementMqService;

    @Autowired
    private OrderChildBrokerMqService orderChildBrokerMqService;


    @Override
    public void updateInvoiceCompany(List<SettlementOwnerDetail> list){
        for (SettlementOwnerDetail item : list) {

            // 发送mq （开票公司更新）
            settlementMqService.updateInvoiceCompany(item.getId());
        }

    }

    @Override
    public void updatePaySuccess(SettlementOwnerDetail settlementOwnerDetail) {
        // 发送mq (更新无车承运)
        orderChildBrokerMqService.orderChildUpdate(settlementOwnerDetail.getChildNo());
    }
}
