package com.clx.performance.listener.linewarn;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyLineWarnConstants;
import com.clx.performance.param.mq.linewarn.LineWarnNoticeMqParam;
import com.clx.performance.service.linewarn.LineWarnMqHandlerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 线路预警通知 mq
 * @Date: 2023-10-20 16:34:40
 * @Version: 1.0
 */
@Slf4j
@Component
public class LineWarnTruckNoticeListener {

    @Autowired
    private LineWarnMqHandlerService lineWarnMqHandlerService;

    @RabbitListener(queues = RabbitKeyLineWarnConstants.LINE_WARN_NOTICE_QUEUE)
    public void process(Message message) {
        try{
            log.info("线路预警-预警通知, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<LineWarnNoticeMqParam>>(){}).getData());
        }catch (Exception e){
            log.info("线路预警-预警通知 失败",e);
        }
    }

    private void process(LineWarnNoticeMqParam mq){

        lineWarnMqHandlerService.notice(mq);

    }
}
