package com.clx.performance.vo.app;

import com.clx.performance.enums.OrderChildEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.List;

/**
* @Author: aiqinguo
* @Description: 运单表
* @Date: 2023/09/19 16:49:06
* @Version: 1.0
*/

@ApiModel(description = "运单表")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildVO {

    @ApiModelProperty(value = "id", example = "1")
    private Integer id;
    @ApiModelProperty(value = "用户编号", example = "10000000000")
    private Long userNo;
    @ApiModelProperty(value = "货主用户编号", example = "100000000")
    private Long ownerUserNo;
    @ApiModelProperty(value = "货主名称", example = "张三")
    private String ownerName;
    @ApiModelProperty(value = "运单编号", example = "100000000")
    private String childNo;
    @ApiModelProperty(value = "货单编号", example = "100000000")
    private String orderGoodsNo;
    @ApiModelProperty(value = "订单编号", example = "10000000000")
    private String orderNo;

    @ApiModelProperty(value = "货物id", example = "1")
    private Integer goodsId;
    @ApiModelProperty(value = "货物名称", example = "煤")
    private String goodsName;
    @MoneyOutConvert
    @ApiModelProperty(value = "运费单价（元）", example = "1.23")
    private BigDecimal freightPrice;
    @ApiModelProperty(value = "发货地址id", example = "1")
    private Integer sendAddressId;
    @ApiModelProperty(value = "发货地址", example = "朝阳")
    private String sendAddress;
    @ApiModelProperty(value = "收货地址id", example = "2")
    private Integer receiveAddressId;
    @ApiModelProperty(value = "收货地址", example = "西城")
    private String receiveAddress;
    @ApiModelProperty(value = "最晚装货时间", example = "")
    private String loadDeadline;

    @ApiModelProperty(value = "车主id", example = "1")
    private Long truckOwnUserNo;
    @ApiModelProperty(value = "车主姓名", example = "李四")
    private String truckOwnName;
    @ApiModelProperty(value = "车辆ID", example = "1")
    private Integer truckId;
    @ApiModelProperty(value = "车牌号", example = "京A12345")
    private String truckNo;
    @ApiModelProperty(value = "载重（单位吨）", example = "12.34")
    private BigDecimal truckLoad;
    @ApiModelProperty(value = "车型", example = "挂车")
    private String truckModel;

    @ApiModelProperty(value = "司机用户编号", example = "1000000")
    private Long driverUserNo;
    @ApiModelProperty(value = "司机姓名", example = "张三")
    private String driverName;
    @ApiModelProperty(value = "司机手机号", example = "130000000")
    private String driverMobile;

    @ApiModelProperty(value = "装货毛重（单位吨）", example = "1.23")
    private BigDecimal loadRough;
    @ApiModelProperty(value = "装货皮重（单位吨）", example = "1.23")
    private BigDecimal loadTare;
    @ApiModelProperty(value = "装货净重（单位吨）", example = "1.23")
    private BigDecimal loadNet;
    @ApiModelProperty(value = "卸货毛重（单位吨）", example = "1.23")
    private BigDecimal unloadRough;
    @ApiModelProperty(value = "卸货皮重（单位吨）", example = "1.23")
    private BigDecimal unloadTare;
    @ApiModelProperty(value = "卸货净重（单位吨）", example = "1.23")
    private BigDecimal unloadNet;
    @ApiModelProperty(value = "卸货磅单编号", example = "url")
    private String unloadPoundNo;

    @ApiModelProperty(value = "拉运重量（单位吨）", example = "1.23")
    private BigDecimal weight;
    @ApiModelProperty(value = "运费（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freight;
    @ApiModelProperty(value = "损耗单价(分)", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossPrice;
    @ApiModelProperty(value = "合同运费单价", example = "1.23")
    @MoneyOutConvert
    private BigDecimal orderFreightPrice;

    @ApiModelProperty(value = "取消原因", example = "取消原因类型：1个人原因, 2价格不合适, 3无法装货, 4车辆原因, 5交通管制, 6交通事故, 7无法找到地址, 8排队时间较长, 9其他原因")
    private Integer cancelType;
    @ApiModelProperty(value = "取消原因", example = "抢错了")
    private String cancelRemark;
    @ApiModelProperty(value = "司机取消详细原因", example = "司机取消详细原因")
    private String cancelDetail;
    @ApiModelProperty(value = "磅单审核状态 0 待审核 1 审核通过 2 审核驳回", example = "0")
    private Integer poundStatus;
    @ApiModelProperty(value = "磅单审核驳回原因", example = "交货信息错误")
    private String poundRemark;
    @ApiModelProperty(value = "审核驳回类型：1装车 2卸车 3装车+卸车", example = "1")
    private Integer poundRejectType;
    @ApiModelProperty(value = "状态", example = "0")
    private Integer status;
    @ApiModelProperty(value = "运输状态 0非运输中 1运输中", example = "1")
    private Integer transitStatus;
    public Integer getTransitStatus() {
        return status==null || !OrderChildEnum.TRANSIT_lIST.contains(status)? 0 : 1;
    }

    @ApiModelProperty(value = "支付时间(抢单时间)", example = "")
    private String payTime;
    @ApiModelProperty(value = "装车时间", example = "")
    private String loadTime;
    @ApiModelProperty(value = "卸车时间", example = "")
    private String unloadTime;
    @ApiModelProperty(value = "司机确认交货时间", example = "")
    private LocalDateTime confirmTime;
    @ApiModelProperty(value = "结算时间", example = "")
    private String settleTime;
    @ApiModelProperty(value = "取消时间", example = "")
    private String cancelTime;
    @ApiModelProperty(value = "完成时间", example = "")
    private String finishTime;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;
    @ApiModelProperty(value = "修改时间", example = "")
    private String modifiedTime;

    @ApiModelProperty(value = "装车磅单图片列表")
    private List<String> loadImageList;

    @ApiModelProperty(value = "卸车磅单图片列表")
    private List<String> unloadImageList;

    @ApiModelProperty(value = "发货地址详情")
    private Address sendAddressInfo;
    @ApiModelProperty(value = "发货地址详情")
    private Address receiveAddressInfo;

    @ApiModelProperty(value = "总运费（元）", example = "1.23")
    private BigDecimal totalFreight;
    public BigDecimal getTotalFreight() {
        return freightPrice.multiply(weight).setScale(2, RoundingMode.HALF_UP);
    }

    @ApiModelProperty("状态MSG")
    public String statusMsg;
    public String getStatusMsg() {
        return OrderChildEnum.Status.getByCode(status).get().getName();
    }

    @ApiModelProperty("货物类型名称")
    public String goodTypeName;


    @ApiModelProperty("'最晚到达目的地时间'")
    private String lastArriveReceiveTime;
    @ApiModelProperty("最晚到达货源地时间")
    private String lastArriveSendTime;
    @ApiModelProperty("最晚装货时间")
    private String lastLoadTime;


    //结算信息
    @ApiModelProperty(value = "实际运费", example = "1.23")
    @MoneyOutConvert
    private BigDecimal realFreight;
    @ApiModelProperty(value = "货损金额", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossFreight;
    @ApiModelProperty(value = "预付运费金额", example = "1.23")
    @MoneyOutConvert
    private BigDecimal prepayFreight;
    @ApiModelProperty(value = "结算金额", example = "1.23")
    @MoneyOutConvert
    private BigDecimal settlementFreight;



    //运单详情增加字段
    @ApiModelProperty(value = "亏吨重量", example = "1.23")
    private BigDecimal lossWeight;
    @ApiModelProperty(value = "亏吨扣款", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossAmount;

    @ApiModelProperty(value = "车辆未开启中交兴路的提示信息")
    private String notOpenZJXLMsg;


}