package com.clx.performance.controller.feign;

import cn.hutool.core.collection.CollectionUtil;
import com.clx.performance.model.OrderChild;
import com.clx.performance.service.OrderChildService;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;
import java.util.List;

@RestController
@RequestMapping("/feign/orderChild")
@Validated
@Api(tags = "运单Feign")
@AllArgsConstructor
public class OrderChildFeignController {

    private final OrderChildService orderChildService;

    @GetMapping({"/getOrderChildTotalByUserNo"})
    Integer getTrucksByOrderGoodsNo(@RequestParam("userNo") @NotNull(message = "用户编号不可为空") Long userNo) {
        Integer totalByUserNo = orderChildService.getOrderChildTotalByUserNo(userNo);
        return totalByUserNo;
    }

    /**
     * 查询在途运单
     *
     * @param orderNo
     * @return
     */
    @GetMapping({"/selectInTransitOrderChild"})
    Result<Boolean> selectInTransitOrderChild(@RequestParam("orderNo") String orderNo) {
        List<OrderChild> orderChildren = orderChildService.selectInTransitOrderChild(orderNo);
        if (CollectionUtil.isNotEmpty(orderChildren)) {
            return Result.ok(true);
        } else {
            return Result.ok(false);
        }
    }
}
