package com.clx.performance.vo.pc;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderGoodsEditVO {

    @ApiModelProperty("订单编号")
    private String orderNo;
    @ApiModelProperty("拉运结束时间")
    private String transportEndTime;
    @ApiModelProperty("拉运吨数")
    private BigDecimal transportWeight;
    @ApiModelProperty("有效运费")
    @MoneyOutConvert
    private BigDecimal validFreightPrice;
    @ApiModelProperty("用车需求： 1平台车辆 2部分平台车辆 3自有车辆")
    private Integer truckDemand;
    @ApiModelProperty("剩余拉运吨数")
    private String residueWeight;
    @ApiModelProperty("自有承运吨数")
    private String ownCarryWeight;
    @ApiModelProperty("自有承运剩余吨数")
    private String ownResidueCarryWeight;
    @ApiModelProperty("平台承运吨数")
    private String platformCarryWeight;
    @ApiModelProperty("平台剩余承运吨数")
    private String platformResidueCarryWeight;
    @ApiModelProperty("向下浮动量（吨）")
    private String downFloatWeight;
    @ApiModelProperty("向上浮动量（吨）")
    private String upFloatWeight;
    @ApiModelProperty("是否暂停 0：否   1：是")
    private Integer stopFlag;
    @ApiModelProperty("结算账期  1拉运完成结  2月结")
    private Integer settlementAccountPeriod;
    @ApiModelProperty("1:可以全部编辑 0：不能全部编辑")
    private boolean editAllFlag;

    private OrderGoodsVO orderGoodsVO;
}
