package com.clx.performance.param.pc.payment;

import lombok.*;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class PayUnitDTO {
	/** 支付单元唯一标识*/
	private String id;
	/** 谁支付 用户钱包编号 */
	private Integer from;
	/** 支付给谁 用户钱包编号 支付给系统时为10000 **/
	private Integer to;
	/** 交易金额(单位分) 必须为正数 **/
	private Integer figure;
	/** 支付类型  参考 <PayUnitTypeEnum> **/
	private Integer type;
	/** 时间戳(单位毫秒) **/
	private Long timestamp;
	/** 签名使用业务系统私钥签名 不参与签名 **/
	private String signature;
	/** 备注 不参与签名 可空 */
	private String remark;
	/** 关联名称 不参与签名 可空 */
	private String relationName;
	/** 优惠卷id */
	private Integer userCouponId;
	/** 订单编码 批量发送 单独处理的订单号 */
	private String orderNo;
}
