package com.clx.performance.controller.app.owner;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.owner.PageOwnerOrderChildListParam;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.vo.app.OrderChildVO;
import com.clx.performance.vo.app.owner.OwnerOrderChildVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import com.msl.user.utils.TokenUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @ClassName AppOwnerOrderChildController
 * @Description
 * @Author kavin
 * @Date 2023/12/22 14:51
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping(value="/app/owner/orderChild")
@Validated
@Api(tags = "APP-货主运单")
@AllArgsConstructor
public class AppOwnerOrderChildController {

    @Autowired
    OrderChildService orderChildService;

    @ApiOperation(value = "运单列表", notes = "<br>By:刘海泉")
    @PostMapping("/pageOwnerOrderChildList")
    public Result<PageData<OwnerOrderChildVO>> pageOwnerOrderChildList(@RequestBody @Validated PageOwnerOrderChildListParam param) {
        param.setOwnerUserNo(TokenUtil.getLoginUserInfo().getUserNo());
        IPage<OwnerOrderChildVO> page  = orderChildService.pageOwnerOrderChildList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @ApiOperation(value = "查询运单详情", notes = "<br>By:刘海泉")
    @UnitCovert(param = false)
    @GetMapping("/getOrderChildInfo")
    public Result<OrderChildVO> getOrderChildInfo(String childNo) {
        return Result.ok(orderChildService.getOwnerOrderChildInfo(childNo));
    }


}
