package com.clx.performance.enums.payment;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum PaymentActionEnum {
    ;
    /** 操作类型 1撤销 2完成 3修改*/
    @Getter
    @AllArgsConstructor
    public enum Type {
        CANCEL(1, "撤销"),
        COMPLETE(2, "完成"),
        ADJUST(3, "修改"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<Type> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Type::getMsg).orElse(null);
        }
    }


}
