package com.clx.performance.vo.pc.loan.owner;

import com.clx.performance.enums.loan.OwnerLoanRecordEnum;
import com.clx.performance.enums.loan.OwnerRePaymentEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @ClassName OwnerRepayment
 * @Description
 * @Author kavin
 * @Date 2024/1/20 15:18
 * @Version 1.0
 */
@Getter
@Setter
public class ExportOwnerRepaymentVO {

    private Integer id;

    
    @ApiModelProperty("货主编码")
    private String ownerUserNo;

    
    @ApiModelProperty("货主名称")
    private String ownerUserName;

    
    @ApiModelProperty("联系电话")
    private String mobile;

    
    @ApiModelProperty("交易流水号（第三方）")
    private String runningWaterOpenNo;

    @ApiModelProperty("商户流水号")
    private String merchantRunningWaterNo;

    
    @ApiModelProperty("还款单号")
    private Long repaymentNo;

    @ApiModelProperty("还款金额")
    private BigDecimal repaymentBalance;

    public BigDecimal getRepaymentBalance(){
        return Objects.isNull(repaymentBalance)?BigDecimal.ZERO:repaymentBalance.movePointLeft(2);
    }


    
    @ApiModelProperty("付款方")
    private String payment;

    
    @ApiModelProperty("付款账户")
    private String paymentAccount;


    @ApiModelProperty("汇款识别码")
    private String remittanceIdentificationCode;


    
    @ApiModelProperty("收款方")
    private String payee;

    
    @ApiModelProperty("收款账户")
    private String payeeAccount;


    @ApiModelProperty("货物名称")
    private String goodsName;


    @ApiModelProperty("借款单号")
    private Long loanNo;


    @ApiModelProperty("10 待付款 40 付款中 50 付款成功 60 付款失败")
    private Integer status;


    @ApiModelProperty("10 待付款 40 付款中 50 付款成功 60 付款失败")
    private String statusMsg;

    public String getStatusMsg(){
        return OwnerRePaymentEnum.Status.getMsgByCode(status);
    }


    
    @ApiModelProperty("支付渠道 1 订单支付 2 转账支付")
    private Integer payChannel;

    @ApiModelProperty("支付渠道 1 订单支付 2 转账支付")
    private String payChannelMsg;

    public String getPayChannelMsg(){
        return OwnerLoanRecordEnum.PayChannel.getMsgByCode(payChannel);
    }

    
    @ApiModelProperty("10 未逾期  20 已逾期")
    private Integer beOverdue;

    @ApiModelProperty("10 未逾期  20 已逾期")
    private String beOverdueMsg;

    public String getBeOverdueMsg(){
        return OwnerRePaymentEnum.BeOverdue.getMsgByCode(beOverdue);
    }
    
    @ApiModelProperty("借款归还时间")
    private String loanRepaymentTime;

    
    @ApiModelProperty("操作时间")
    private String operateTime;

    
    @ApiModelProperty("操作人")
    private String operateBy;

    
    @ApiModelProperty("创建人")
    private String createBy;

    
    @ApiModelProperty("生成付款申请单时间")
    private String createTime;

    
    @ApiModelProperty("修改时间")
    private String modifiedTime;


    @ApiModelProperty("收款银行")
    private String payeeBank;


    @ApiModelProperty("收款行号")
    private String payeeBankCode;

}
