package com.clx.performance.vo.pc.carrier.settle;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.List;


@Getter
@Setter
@ToString
@NoArgsConstructor
public class CarrierSettlementOwnerDetailVO {

    @ApiModelProperty(value = "id", example = "1.23")
    private Integer id;

    @ApiModelProperty(value = "货主用户编号", example = "123")
    private Long ownerUserNo;

    @ApiModelProperty(value = "货主名称", example = "货主")
    private String ownerName;

    @ApiModelProperty("结算方式  1装车净重 2卸车净重")
    private Integer settlementWay;

    @ApiModelProperty(value = "结算单编号", example = "JS415")
    private String settlementNo;

    @ApiModelProperty(value = "结算子单号", example = "JS012")
    private String settlementSubNo;

    @ApiModelProperty(value = "结算周期类型：1拉运完成结 2月结", example = "")
    private Integer settlementPeriodType;
    @ApiModelProperty(value = "结算周期时间（月结）", example = "")
    private String settlementPeriodTime;

    @ApiModelProperty(value = "订单编号", example = "123")
    private String orderNo;

    @ApiModelProperty(value = "实际净重（吨）", example = "1.23")
    private BigDecimal weight;

    @ApiModelProperty(value = "实际运费（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freight;

    @ApiModelProperty(value = "货损吨数（吨）", example = "1.23")
    private BigDecimal lossWeight;

    @ApiModelProperty(value = "货损金额（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossFreight;

    @ApiModelProperty(value = "预付运费金额（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal prepayFreight;

    @ApiModelProperty(value = "结算金额（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal settlementFreight;

    @ApiModelProperty(value = "借款金额（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal loanFreight;

    @ApiModelProperty(value = "开票标识：1网运单 2普通单", example = "1")
    private Integer invoiceTypeCode;

    @ApiModelProperty(value = "开票标识：1网运单 2普通单", example = "网运单")
    private String invoiceTypeMsg;

    @ApiModelProperty(value = "开票金额（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal invoiceFreight;

    @ApiModelProperty(value = "结算凭证", example = "/a.png")
    private String invoiceImg;

    @ApiModelProperty(value = "收款人", example = "收款人")
    private String payee;

    @ApiModelProperty(value = "收款银行", example = "浙江银行")
    private String payeeBankName;

    @ApiModelProperty(value = "收款银行卡卡号", example = "62213545878787")
    private String payeeBankCardNo;

    @ApiModelProperty(value = "付款凭证", example = "/a.png")
    private String paymentImg;

    @ApiModelProperty(value = "付款银行", example = "浙江银行")
    private String paymentBankName;

    @ApiModelProperty(value = "付款银行卡卡号", example = "62213545878787")
    private String paymentBankCardNo;

    @ApiModelProperty(value = "公司名称", example = "公司名称")
    private String companyName;

    @ApiModelProperty(value = "企业税号", example = "企业税号")
    private String companyTaxCode;

    @ApiModelProperty(value = "公司地址", example = "公司地址")
    private String companyAddress;

    @ApiModelProperty(value = "公司电话", example = "1222222222")
    private String companyMobile;

    @ApiModelProperty(value = "公司开户行", example = "中国银行")
    private String companyBankName;

    @ApiModelProperty(value = "公司银行账号", example = "6215454545")
    private String companyBankNo;

    @ApiModelProperty(value = "公司联系人", example = "1.23")
    private String companyContact;

    @ApiModelProperty(value = "公司联系电话", example = "公司联系人")
    private String companyContactMobile;

    @ApiModelProperty(value = "公司联系地址", example = "公司联系地址")
    private String companyContactAddress;

    @ApiModelProperty(value = "快递公司", example = "顺风")
    private String expressCompany;

    @ApiModelProperty(value = "快递编号", example = "SF145787")
    private String expressNo;

    @ApiModelProperty(value = "开票状态code 1-已开票 2-部分开票 3-无需开票", example = "1")
    private Integer invoiceStatusCode;

    @ApiModelProperty(value = "开票状态Msg 1-已开票 2-部分开票 3-无需开票", example = "无需开票")
    private String invoiceStatusMsg;

    @ApiModelProperty(value = "状态code 10:待锁定  20:待对账  30:待货主确认 40:待货主付款 50:待平台确认付款 60:待平台付款 70:待货主确认付款 80:待邮寄发票 90:已完结", example = "10")
    private Integer statusCode;

    @ApiModelProperty(value = "状态Msg", example = "待锁定")
    private String statusMsg;

    @ApiModelProperty(value = "驳回原因", example = "驳回原因")
    private String remark;

    @ApiModelProperty(value = "创建时间", example = "2023-01-01 00:00:00")
    private String createTime;

    @ApiModelProperty(value = "结算单合并明细")
    private List<SettlementMergeVO> mergers;

    @ApiModelProperty(value = "结算单操作日志")
    private List<SettlementLogVO> settlementLogs;


}