package com.clx.performance.controller.pc;


import com.clx.performance.param.pc.OrderCancelParam;
import com.clx.performance.service.OrderCancelService;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value="/pc/order/")
@Validated
@Api(tags = "PC-订单取消")
@AllArgsConstructor
public class OrderCancelController {

    private final OrderCancelService orderCancelService;

    @ApiOperation(value = "承运端取消订单", notes = "<br>By:胡宇帆")
    @PostMapping("/platformCancelOrderPre")
    public Result<Object> platformCancelOrderPre(@RequestParam OrderCancelParam param) {
        orderCancelService.platformCancelOrderPrePC(param);
        return Result.ok();
    }

    @ApiOperation(value = "货主端取消订单", notes = "<br>By:胡宇帆")
    @PostMapping("/ownCancelOrderPre")
    public Result<Object> ownCancelOrderPre(@RequestParam OrderCancelParam param) {
        orderCancelService.ownerCancelOrderPrePC(param);
        return Result.ok();
    }
}
