package com.clx.performance.vo.pc.breakcontract.carrier;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
public class BreakContractDriverRuleVO {

    @ApiModelProperty(value = "司机取消规则")
    private DriverCancelRule driverCancelRule;

    @ApiModelProperty(value = "货源地超时规则")
    private SendAddressRule sendAddressRule;

    @ApiModelProperty(value = "目的地超时规则")
    private ReceiveAddressRule receiveAddressRule;

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class DriverCancelRule{

        @ApiModelProperty("接单时间小于X小时")
        @NotNull(message = "参数不能为空")
        private BigDecimal baseTime;

        @ApiModelProperty("收费X元")
        @NotNull(message = "参数不能为空")
        private BigDecimal baseFigure;

        @ApiModelProperty("每小时加收X元")
        @NotNull(message = "参数不能为空")
        private BigDecimal figurePerHour;
    }

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class SendAddressRule{
        @ApiModelProperty("每小时收X元")
        @NotNull(message = "参数不能为空")
        private BigDecimal figurePerHour;
    }

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class ReceiveAddressRule{
        @ApiModelProperty("每小时每吨收X元")
        @NotNull(message = "参数不能为空")
        private BigDecimal figurePerHour;
    }

}
