package com.clx.performance.job.trace;

import com.clx.performance.service.trace.TruckTraceMqService;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.user.feign.UserClxFeign;
import com.msl.common.job.JobLog;
import com.msl.common.result.Result;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

@Slf4j
@Component
@AllArgsConstructor
public class PlatTruckTraceJob {

    private final UserClxFeign userClxFeign;
    private final TruckTraceMqService truckTraceMqService;


    /**
     * 车辆轨迹同步
     */
    @XxlJob("platTruckTraceSync")
    public void platTruckTraceSync() {
        try {
//            Result<List<String>> result = userClxFeign.getPlatformTruckList();
            Result<List<String>> result = new Result<>();
            result.setData(Arrays.asList("陕KJ9799", "陕KM5365", "晋HG7149", "晋HC3023", "晋HJ3338"));
            if(result.succeed()){
                log.info("平台车辆轨迹开始同步, size:{}", result.getData().size());

                for (String truckNo : result.getData()) {
                    LocalDateTime now = LocalDateTime.now();
                    LocalDateTime beginTime = now.minusSeconds(600);
                    // 发送mq (同步车辆轨迹)
                    truckTraceMqService.truckTracSync( truckNo, LocalDateTimeUtils.formatTime(beginTime), LocalDateTimeUtils.formatTime(now));
                }
                log.info("平台车辆轨迹结束同步================");
            }
        } catch (Exception e) {
            log.warn("平台车辆轨迹同步失败，异常原因:{}", ExceptionUtils.getStackTrace(e));
            JobLog.error("平台车辆轨迹同步失败，异常原因=====================", e);
        }
    }

}
