package com.clx.performance.controller.temp;

import com.clx.message.feign.ClxMessageOpenapiFeign;
import com.clx.message.req.batch.ClinkBatchMessageReq;
import com.clx.message.req.message.ClinkMessageReq;
import com.clx.performance.config.ClxMessageConfig;
import com.clx.performance.extranal.transport.TransportService;
import com.clx.performance.feign.TransportFeignService;
import com.clx.performance.listener.OrderChildDtsListener;
import com.clx.performance.service.TempService;
import com.clx.performance.service.child.FeignOrderChildService;
import com.clx.performance.service.child.OrderChildPostService;
import com.msl.common.result.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @Author: aiqingguo
 * @Description: 临时接口
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/temp")
public class TempController {

    @Autowired
    private TempService tempService;
    @Autowired
    private FeignOrderChildService carrierOrderChildService;
    @Autowired
    private TransportService transportService;
    @Autowired
    private TransportFeignService transportFeignService;

    @Autowired
    private OrderChildDtsListener orderChildDtsListener;
    @Autowired
    private ClxMessageConfig clxMessageConfig;
    @Autowired
    private ClxMessageOpenapiFeign clxMessageOpenapiFeign;
    @Autowired
    private OrderChildPostService orderChildPostService;

    @ApiOperation(value = "test", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/test", method = RequestMethod.POST)
    public Result test( String mobile, String warnName, String truckNo, String childNo) {
        //触发{指定预警名称}预警；车牌号{车牌号}；运单{运单号}；请尽快核实情况
        ClinkMessageReq req = new ClinkMessageReq();

        StringBuilder sb = new StringBuilder();
        sb.append("触发");
        sb.append(warnName);
        sb.append("预警；车牌号");
        sb.append(truckNo);
        sb.append("；运单");
        sb.append(childNo);
        sb.append("；请尽快核实情况");

        String content = sb.toString();

        req.setChannelId(clxMessageConfig.getChannelId());
        req.setAppId(clxMessageConfig.getAppId().toString());
        req.setMobile(mobile);
        req.setContent(content);
        clxMessageOpenapiFeign.sendClink(req);

        return Result.ok();
    }
    @ApiOperation(value = "orderChildAdd", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/orderChildAdd", method = RequestMethod.POST)
    public Result orderChildAdd( String mobile, String warnName, String truckNo, String childNo) {
        orderChildPostService.orderChildAdd("123");

        return Result.ok();
    }


//    @ApiOperation(value = "更新网运标识", notes = "<br>By:艾庆国")
//    @RequestMapping(value = "/updateInvoiceType", method = RequestMethod.POST)
//    public Result<Void> updateInvoiceType(String childNo, Integer invoiceType) {
//
//        tempService.updateInvoiceType(childNo, invoiceType);
//
//        return Result.ok();
//    }


//    @ApiOperation(value = "司机违约结算单完成 (临时接口)", notes = "<br>By:艾庆国")
//    @RequestMapping(value = "/updateBreakContractDriverSettlementFinish", method = RequestMethod.POST)
//    public Result<Void> updateBreakContractDriverSettlementFinish(String settlementNo) {
//
//        tempService.updateBreakContractDriverSettlementFinish(settlementNo);
//
//        return Result.ok();
//    }

//    @ApiOperation(value = "测试支付划账 (临时接口)", notes = "<br>By:胡宁宁")
//    @RequestMapping(value = "/paymentTest", method = RequestMethod.GET)
//    public Result<Void> paymentTest(@RequestParam("fromUser") @NotBlank(message = "扣款方") String fromUser,
//                                    @RequestParam("toUser") @NotBlank(message = "收款方") String toUser,
//                                    @RequestParam("figure") @NotBlank(message = "金额") String figure) {
//
//        tempService.paymentTest(fromUser,toUser,figure);
//
//        return Result.ok();
//    }


//    @ApiOperation(value = "承运同步网络货运 (临时接口)", notes = "<br>By:艾庆国")
//    @RequestMapping(value = "/orderChildSync", method = RequestMethod.GET)
//    public Result<Void> orderChildSync(@RequestBody ThirdOrderChildBrokerParam param1) {
//        ThirdOrderChildBrokerParam param = new ThirdOrderChildBrokerParam();
//        param.setChildNo("123");
//
//        transportService.orderChildSync(param);
//
//        return Result.ok();
//    }

//    @ApiOperation(value = "运单支付运费同步 (临时接口)", notes = "<br>By:艾庆国")
//    @RequestMapping(value = "/orderChildPaySync", method = RequestMethod.POST)
//    public Result<Void> orderChildPaySync(@RequestBody OrderChildPaySyncParam param) {
//
//        HttpDTO httpDTO = transportFeignService.orderChildPaySync(param);
//        String decrypt = ThirdComponent.decrypt(httpDTO.getData());
//        log.info("{}", decrypt);
//        return Result.ok();
//    }

//    @ApiOperation(value = "货主结算单同步 (临时接口)", notes = "<br>By:艾庆国")
//    @RequestMapping(value = "/ownerSettlementSync", method = RequestMethod.POST)
//    public Result<Void> ownerSettlementSync(@RequestBody OwnerSettlementSyncParam param) {
//
//        HttpDTO httpDTO = transportFeignService.ownerSettlementSync(param);
//        String decrypt = ThirdComponent.decrypt(httpDTO.getData());
//        log.info("{}", decrypt);
//        return Result.ok();
//    }

//    @ApiOperation(value = "获取风控状态 (临时接口)", notes = "<br>By:艾庆国")
//    @RequestMapping(value = "/getRiskStatus", method = RequestMethod.POST)
//    public Result<Void> getRiskStatus(String childNo) {
//        ThirdOrderChildRiskStatusParam param = ThirdOrderChildRiskStatusParam.builder().build();
//        param.setChildNo(childNo);
//        HttpDTO httpDTO = transportFeignService.getRiskStatus(param);
//        String decrypt = ThirdComponent.decrypt(httpDTO.getData());
//        log.info("{}", decrypt);
//        return Result.ok();
//    }

}
