/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.x509.X509ObjectIdentifiers;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.crypto.params.RSAPrivateCrtKeyParameters;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class RSAUtil {
    public static boolean isRsaOid(DERObjectIdentifier algOid) {
        return algOid.equals(PKCSObjectIdentifiers.rsaEncryption) || algOid.equals(X509ObjectIdentifiers.id_ea_rsa) || algOid.equals(PKCSObjectIdentifiers.id_RSASSA_PSS) || algOid.equals(PKCSObjectIdentifiers.id_RSAES_OAEP);
    }

    public static RSAKeyParameters generatePublicKeyParameter(RSAPublicKey key) {
        return new RSAKeyParameters(false, key.getModulus(), key.getPublicExponent());
    }

    public static RSAKeyParameters generatePrivateKeyParameter(RSAPrivateKey key) {
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey k = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeyParameters(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
        }
        RSAPrivateKey k = key;
        return new RSAKeyParameters(true, k.getModulus(), k.getPrivateExponent());
    }
}

