package com.clx.performance.vo.pc.carrier.settle;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


/**
 * @author yangqifa
 */
@Getter
@Setter
@ToString
public class CarrierPagePlatformServiceFeeConfigVO {

    @Schema(description = "id")
    private Integer id;
    @Schema(description = "订单报价方式,0:未税,1:含税")
    private Integer orderQuotationType;
    @Schema(description = "订单报价方式")
    private String orderQuotationTypeMsg;
    @Schema(description = "接单保证金")
    @MoneyOutConvert
    private BigDecimal deposit;
    @Schema(description = "平台服务费费率")
    private BigDecimal serviceFeeRate;
}
