package com.clx.performance.vo.pc.breakcontract.carrier;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


@Getter
@Setter
@ToString
@NoArgsConstructor
public class PageCarrierBreakContractSettlementDriverVO {

    @Schema(description="id")
    private Integer id;

    @Schema(description="违约方类型：1平台 2货主 3车主")
    private Integer breakContractPartyType;

    @Schema(description="违约方类型Msg：1平台 2货主 3车主")
    private String breakContractPartyTypeMsg;

    @Schema(description="结算单编号")
    private String settlementNo;

    @Schema(description="车主用户编号")
    private Long truckOwnUserNo;

    @Schema(description="车主名称")
    private String truckOwnName;

    @Schema(description="司机名称")
    private String driverName;

    @Schema(description="运单编号")
    private String childNo;

    @MoneyOutConvert
    @Schema(description="违约金（分）")
    private BigDecimal figure;

    @Schema(description="违约说明")
    private String breakContractRemark;

    @Schema(description="结算状态 1待结算;2已结算")
    private String settleStatusMsg;

    @Schema(description="结算状态 1待结算;2已结算")
    private Integer settleStatus;

    @Schema(description="结算平台 0马上来")
    private String settlePlatformMsg;

    @Schema(description="结算平台 0马上来")
    private Integer settlePlatform;

    @Schema(description="结算时间")
    private String settleTime;

    @Schema(description="支付备注")
    private String payRemark;

    @Schema(description="操作人名称")
    private String createName;

    @Schema(description="创建时间")
    private String createTime;


}