package com.clx.performance.vo.pc;

import com.clx.performance.enums.SyncPlatformEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;



@Getter
@Setter
@NoArgsConstructor
public class PageCarrierOrderChildVO {

    @Schema(description="运单编号",example = "41441")
    private String childNo;

    @Schema(description="运单状态",example = "1")
    private Integer status;

    @Schema(description="订单编号",example = "41441")
    private String orderNo;

    @Schema(description="货单编号",example = "41441")
    private String orderGoodsNo;

    @Schema(description="货物名称",example = "煤炭")
    private String goodsName;

    @Schema(description="司机姓名",example = "张安")
    private String driverName;

    @Schema(description="司机手机号",example = "12222222222")
    private String driverMobile;

    @Schema(description = "运费单价（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freightPrice;

    @Schema(description="装货净重",example = "10")
    private BigDecimal loadNet;

    @Schema(description="卸货净重",example = "41")
    private BigDecimal unloadNet;

    @Schema(description = "装货毛重", example = "10")
    private BigDecimal loadRough;

    @Schema(description = "装货皮重", example = "10")
    private BigDecimal loadTare;

    @Schema(description="卸货毛重",example = "41")
    private BigDecimal unloadRough;

    @Schema(description="卸货皮重",example = "41")
    private BigDecimal unloadTare;

    @Schema(description="接单时间",example = "2020-01-01 10:10:10")
    private String payTime;

    @Schema(description="完成时间",example = "2020-01-01 10:10:10")
    private String finishTime;

    @Schema(description="磅单审核通过时间",example = "2020-01-01 10:10:10")
    private String poundAuditTime;

    @Schema(description="发货地址",example = "吉林")
    private String sendAddress;

    @Schema(description="收货地址",example = "山西")
    private String receiveAddress;

    @Schema(description = "车牌号",example = "晋A12345")
    private String truckNo;

    @Schema(description = "订单来源")
    private Integer orderSource;
    private String orderSourceMsg;
    public String getOrderSourceMsg() {
        return SyncPlatformEnum.Source.getNameByCode(orderSource);
    }

}