package com.clx.performance.vo.pc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.msl.common.utils.LocalDateTimeUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
* @Author: aiqinguo
* @Description: 积分排名统计
* @Date: 2023-10-10 20:33:01
* @Version: 1.0
*/

@Schema(description = "积分排名统计")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class IntegralStatisticsVO {

    @Schema(description = "统计id", example = "")
    private Integer id;
    @Schema(description = "车牌号", example = "")
    private String truckNo;
    @Schema(description = "统计时间（周一）", example = "")
    private String statisticsDate;
    @Schema(description = "统计时间", example = "")
    private String statisticsDateStr;
    public String getStatisticsDateStr() {
        return statisticsDate.substring(0,10)+"到"+ LocalDateTimeUtils.convertLocalDateTimeToDefaultString(LocalDateTimeUtils.covertStringToDefaultLocalDateTime(statisticsDate).plusDays(6)).substring(0, 10);
    }

    @Schema(description = "积分", example = "")
    private Integer integral;
    public Integer getIntegral() {
        return integral+integralBase;
    }

    @Schema(description = "排名", example = "")
    private Integer rank;
    @Schema(description = "梯队", example = "1")
    private Integer echelon;

    @Schema(description = "创建时间", example = "")
    private String createTime;

    @JsonIgnore
    @Schema(description = "本周基础分", example = "", hidden = true)
    private Integer integralBase;

}