package com.clx.performance.vo.feign.transport;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.util.List;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class ThirdOrderChildBrokerResultVO {

    @Schema(description = "风控结果列表，空未风控")
    private List<RiskItem> riskList;

    @Schema(description = "合规状态：0不合规 1合规")
    private Integer status;

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    @AllArgsConstructor
    public static class RiskItem {
        @Schema(description = "类型", example = "PRICE_LOW")
        private String type;

        @Schema(description = "风控原因", example = "运费单价过低")
        private String msg;
    }

}
