package com.clx.performance.param.pc.owner;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

/**
 * @Author liruixin
 * @create 2023-09-19 13:33
 */
@Getter
@Setter
@NoArgsConstructor
@ToString
public class OwnerPaymentSettlementParam {

    @NotNull(message = "id不能为空")
    @Schema(description="列表id",example = "10")
    private Integer id;

    @NotBlank(message = "收款人不能为空")
    @Schema(description = "收款人", example = "收款人")
    private String payee;

    @NotBlank(message = "收款银行不能为空")
    @Schema(description = "收款银行", example = "浙江银行")
    private String payeeBankName;

    @NotBlank(message = "收款银行卡卡号不能为空")
    @Schema(description = "收款银行卡卡号", example = "62213545878787")
    private String payeeBankCardNo;

    @NotBlank(message = "付款银行不能为空")
    @Schema(description = "付款银行", example = "浙江银行")
    private String paymentBankName;

    @NotBlank(message = "付款银行卡卡号不能为空")
    @Schema(description = "付款银行卡卡号", example = "62213545878787")
    private String paymentBankCardNo;


    @NotBlank(message = "付款凭证不能为空")
    @Schema(description = "付款凭证", example = "/a.png")
    private String paymentImg;

    @Schema(description = "交易密码")
    private String accountPassword;
}
