package com.clx.performance.param.pc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;

/**
 * @ClassName GoodsOrderMapParam
 * @Description
 * @Author kavin
 * @Date 2023/10/10 10:00
 * @Version 1.0
 */
@Getter
@Setter
@Builder
public class GoodsOrderMapParam {

    @NotBlank(message = "创建开始时间不能为空")
    @Schema(description = "创建开始时间", example = "2023-09-30 09:56:29")
    private String beginCreateTime;

    @NotBlank(message = "创建结束时间不能为空")
    @Schema(description = "创建结束时间", example = "2023-10-10 09:56:29")
    private String endCreateTime;

    @NotBlank(message = "收货地址不能为空")
    @Schema(description = "收货地址", example = "黄羊城")
    private String receiveAddress;

    @NotBlank(message = "货单状态不能为空")
    @Schema(description = "货单状态", example = "10：已挂单 20：挂单中 30：运输中  40：已完成  50：已取消  60：已完结 ")
    private String status;


}
