package com.clx.performance.param.feign;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;


@Getter
@Setter
public class OrderAdjustTonnageDownParam {

    @NotBlank(message = "订单编号不能为空")
    @Schema(description="订单编号")
    private String orderNo;

    @NotNull(message = "调整货物吨数不能为空")
    @Schema(description = "调整货物吨数")
    private BigDecimal weight;


    @NotNull(message = "拉运重量不能为空")
    @Schema(description = "拉运重量")
    private BigDecimal transportWeight;

    @NotNull(message = "有效运费不能为空")
    @Schema(description="有效运费")
    private BigDecimal validFreightPrice;

    @NotNull(message = "违约金方案id不能为空")
    @Schema(description="违约金方案id")
    private Integer liquidatedDamagesPlanId;

}
