package com.clx.performance.param.app.collect;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class CollectLineReportReceiveAddressAbnormalSaveParam {

    @Schema(description = "运单编号")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @Schema(description = "无法到达装货地原因", example = "车辆问题")
    @NotBlank(message = "无法到达装货地原因不能为空")
    private String remark;


}
