package com.clx.performance.param.app;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class OrderGoodsListPageParam extends PageParam {

    @Schema(description = "货单类型", example = "1：全部 2：专属")
    @NotBlank(message = "类型")
    private String orderGoodsType;

    @Schema(description = "车牌号", example = "1")
//    @NotNull(message = "车牌号")
    private Integer truckNo;

    @Schema(description = "司机用户编号", example = "1")
//    @NotNull(message = "司机用户编号空")
    private Long driverUserNo;

}
