package com.clx.performance.feign;

import com.clx.performance.param.feign.CancelOrderGoodsParam;
import com.clx.performance.vo.pc.child.OrderChildLineStatisticsVO;
import com.msl.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@FeignClient(name = "clx-performance",configuration = PerformanceClientConfiguration.class)
public interface OrderChildFeign {


    /**
     * 线路运单统计
     */
    @GetMapping("clx-performance/feign/orderChild/lineStatistics")
    Result<OrderChildLineStatisticsVO> lineStatistics(@RequestParam @NotNull(message = "发货地址不可为空") Integer sendSystemAddressId,
                                              @RequestParam @NotNull(message = "收货货地不可为空") Integer receiveSystemAddressId);


    @GetMapping("clx-performance/feign/orderChild/syncLastTruck")
    Result<?> syncLastTruck(@RequestParam("orderNo") @NotBlank(message = "订单编号不能为空") String orderNo);


    @GetMapping("clx-performance/feign/orderChild/getInvoiceType")
    Result<Integer> getInvoiceType(@RequestParam("orderNo") @NotBlank(message = "订单编号不能为空") String orderNo);

    @PostMapping(value = {"clx-performance/feign/orderChild/cancelOrderChild"})
    Result<Object> cancelOrderChild(@RequestBody @Validated CancelOrderGoodsParam param);



    @GetMapping(value = {"clx-performance/feign/orderChild/queryTruckProcessingOrderChild"})
    Long queryTruckProcessingOrderChild(@RequestParam("truckNo") @NotBlank(message = "车牌号不能为空") String truckNo);


}
