
package com.openapi.sdk.util;

import okhttp3.*;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;

public class HttpsUtils2 {

    private static final OkHttpClient client;

    static {
        try {
            // 创建一个信任所有证书的 TrustManager
            TrustManager[] trustAllCerts = new TrustManager[]{
                    new X509TrustManager() {
                        @Override
                        public void checkClientTrusted(X509Certificate[] chain, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] chain, String authType) {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }
            };

            // 安装所有信任的 SSL 套接字工厂
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());

            // 创建一个允许所有主机名的 HostnameVerifier
            HostnameVerifier hostnameVerifier = (hostname, session) -> {
                System.out.println("Warning: URL Host: " + hostname + " vs. " + session.getPeerHost());
                return true;
            };

            ConnectionPool connectionPool = new ConnectionPool(100, 10, TimeUnit.MINUTES);

            // 创建 OkHttpClient 并启用连接池
            client = new OkHttpClient.Builder()
                    .sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager) trustAllCerts[0])
                    .hostnameVerifier(hostnameVerifier)
                    .connectTimeout(10, TimeUnit.SECONDS)
                    .readTimeout(10, TimeUnit.SECONDS)
                    .writeTimeout(10, TimeUnit.SECONDS)
                    .retryOnConnectionFailure(false)
                    .connectionPool(connectionPool)
                    .build();
        } catch (NoSuchAlgorithmException | KeyManagementException e) {
            throw new RuntimeException("Failed to create OkHttpClient", e);
        }
    }

    public static String doPost(String url, int connectTimeout, int readTimeout) throws IOException {
        Request request = new Request.Builder()
                .url(url)
                .post(RequestBody.create("", MediaType.get("application/x-www-form-urlencoded")))
                .build();

        try (Response response = client.newCall(request).execute()) {
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            return response.body().string();
        }
    }

    public static String doPost(String url, String param, int readTimeout, int connectTimeout) throws IOException {
        RequestBody body = RequestBody.create(param, MediaType.get("application/x-www-form-urlencoded"));
        Request request = new Request.Builder()
                .url(url)
                .post(body)
                .build();

        try (Response response = client.newCall(request).execute()) {
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            return response.body().string();
        }
    }
}