package com.clx.performance.strategy;

import com.clx.order.enums.OrderStopEnum;
import com.clx.order.enums.ResultEnum;
import com.clx.order.enums.VehicleUsageEnum;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.performance.dao.OrderGoodsTruckBindDao;
import com.clx.performance.model.OrderGoodsTruckBind;
import com.clx.performance.param.pc.OrderGoodsChildParams;
import com.clx.performance.param.pc.OrderGoodsParams;
import com.clx.performance.utils.SpringContextUtils;
import com.clx.performance.vo.feign.OrderExtractWeightVO;
import com.msl.common.exception.ServiceSystemException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Slf4j
public abstract class GoodsOrderStrategy {


    /**
     * 不同的用车需求执行不同的策略   1：one  2:two 3:three
     * 用车需求： 1平台车辆 2部分平台车辆 3自有车辆
     *
     * @param orderGoodsParams
     * @param orderInfo
     * @param now
     * @return
     */
    public abstract LocalDateTime goodsOrderProcess(OrderGoodsParams orderGoodsParams, FeignOrderVO orderInfo,
            OrderExtractWeightVO orderCanExtractWeight, LocalDateTime now);


    public void saveGoodsOrder(OrderGoodsParams orderGoodsParams, FeignOrderVO orderInfo,
            OrderExtractWeightVO orderCanExtractWeight, LocalDateTime now) {
        if (Objects.equals(orderInfo.getStopFlag(), OrderStopEnum.Status.YES.getCode())) {
            throw new ServiceSystemException(ResultEnum.DATA_ERROR, "订单已暂停，无法进行提量");
        }

        //多个定向单不允许车辆重复
        List<OrderGoodsChildParams> orderGoodsChildParams = orderGoodsParams.getOrderGoodsChildParams();
        Set<String> set = new HashSet<>();
        for (OrderGoodsChildParams item : orderGoodsChildParams) {
            //定向车自由车辆不做拦截操作
            if (!StringUtils.equals(item.getVehicleUsage(),String.valueOf(VehicleUsageEnum.Status.OWN.getCode())) && CollectionUtils.isNotEmpty(item.getTruckList())) {
                int lastSize = set.size() + item.getTruckList().size();
                set.addAll(item.getTruckList());
                if (!Objects.equals(lastSize, set.size())) {
                    throw new ServiceSystemException(ResultEnum.DATA_ERROR, "定向单选择车辆重复");
                }
            }
        }

        if (CollectionUtils.isNotEmpty(set)) {
            OrderGoodsTruckBindDao orderGoodsTruckBindDao = SpringContextUtils.getBeanByClass(OrderGoodsTruckBindDao.class);
            List<OrderGoodsTruckBind> binds = orderGoodsTruckBindDao.judgeTruckIsBindDxOrder(set);
            if (CollectionUtils.isNotEmpty(binds)) {
                List<String> repeatBind = binds.stream().map(OrderGoodsTruckBind::getTruckNo).collect(Collectors.toList());
                String trucks = String.join(", ", repeatBind);
                throw new ServiceSystemException(ResultEnum.DATA_ERROR, "已被定向单绑定车辆：" + trucks);            }
        }
        //根据不同的订单类型创建不同的货单
        goodsOrderProcess(orderGoodsParams, orderInfo,orderCanExtractWeight, now);
    }
}
