package com.clx.performance.controller.pc.trace;

import com.clx.performance.param.pc.trace.QueryTraceParam;
import com.clx.performance.service.trace.TraceMonitorService;
import com.clx.performance.service.trace.TruckTraceService;
import com.clx.performance.vo.pc.trace.OrderChildTraceVO;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotBlank;

/**
 * @ClassName TraceController
 * @Description
 * @Author kavin
 * @Date 2024/5/13 17:54
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping("/pc/carrier/trace/monitor")
@Validated
@Tag(name = "PC-承运轨迹监控")
@AllArgsConstructor
public class TraceController{


    private final TraceMonitorService traceMonitorService;

    @Operation(summary = "运单轨迹监控", description = "<br>By:刘海泉")
    @PostMapping("/getOrderChildTrace")
    public Result<OrderChildTraceVO> getOrderChildTrace(@RequestBody @Validated QueryTraceParam param) {
        return Result.ok(traceMonitorService.getOrderChildTrace(param));
    }



    @Operation(summary = "车辆轨迹监控", description = "<br>By:刘海泉")
    @PostMapping("/getTruckTrace")
    public Result<OrderChildTraceVO> getTruckTrace(@RequestBody @Validated QueryTraceParam param) {
        return Result.ok(traceMonitorService.getTruckTrace(param));
    }

}