package com.clx.performance.controller.pc.linewarn;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.enums.linewarn.LineWarnConfigEnum;
import com.clx.performance.param.pc.linewarn.*;
import com.clx.performance.service.linewarn.LineWarnConfigService;
import com.clx.performance.vo.pc.linewarn.LineWarnConfigVO;
import com.msl.common.base.PageData;
import com.msl.common.enums.ResultCodeEnum;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;


@Slf4j
@RestController
@Validated
@Tag(name = "线路预警-预警配置")
@RequestMapping(value="/pc/lineWarnConfig")
public class LineWarnConfigController {

    @Autowired
    private LineWarnConfigService lineWarnConfigService;

    @Operation(summary = "新增配置", description = "<br>By:艾庆国")
    @PostMapping("/saveConfig")
    public Result<Void> saveConfig(@RequestBody @Validated LineWarnConfigAddParam param) {

        if (Objects.equals(param.getWarnType(), LineWarnConfigEnum.WarnType.TAKE.getCode())
                || Objects.equals(param.getWarnType(), LineWarnConfigEnum.WarnType.LOAD.getCode())
                || Objects.equals(param.getWarnType(), LineWarnConfigEnum.WarnType.UNLOAD.getCode())
        ){
            if (Objects.isNull(param.getTimeRatio())){
                throw new ServiceSystemException(ResultCodeEnum.ILLEGAL_PARAMETER, "时间占比不能为空");}
            if (Objects.isNull(param.getTaskCompleteRatio())){
                throw new ServiceSystemException(ResultCodeEnum.ILLEGAL_PARAMETER, "任务完成占比不能为空");}
        }
        if (Objects.equals(param.getWarnType(), LineWarnConfigEnum.WarnType.CONGESTION.getCode())
        ){
            if (Objects.isNull(param.getCongestionTime())){
                throw new ServiceSystemException(ResultCodeEnum.ILLEGAL_PARAMETER, "交通增加时间不能为空");}
        }

        lineWarnConfigService.saveConfig(param);

        return Result.ok();
    }

    @Operation(summary = "更新配置", description = "<br>By:艾庆国")
    @PostMapping("/updateConfig")
    public Result<Void> updateConfig(@RequestBody @Validated LineWarnConfigUpdateParam param) {
        if (Objects.equals(param.getWarnType(), LineWarnConfigEnum.WarnType.TAKE.getCode())
                || Objects.equals(param.getWarnType(), LineWarnConfigEnum.WarnType.LOAD.getCode())
                || Objects.equals(param.getWarnType(), LineWarnConfigEnum.WarnType.UNLOAD.getCode())
        ){
            if (Objects.isNull(param.getTimeRatio())){
                throw new ServiceSystemException(ResultCodeEnum.ILLEGAL_PARAMETER, "时间占比不能为空");}
            if (Objects.isNull(param.getTaskCompleteRatio())){
                throw new ServiceSystemException(ResultCodeEnum.ILLEGAL_PARAMETER, "任务完成占比不能为空");}
        }
        if (Objects.equals(param.getWarnType(), LineWarnConfigEnum.WarnType.CONGESTION.getCode())
        ){
            if (Objects.isNull(param.getCongestionTime())){
                throw new ServiceSystemException(ResultCodeEnum.ILLEGAL_PARAMETER, "交通增加时间不能为空");}
        }
        lineWarnConfigService.updateConfig(param);
        return Result.ok();
    }

    @Operation(summary = "更新配置状态", description = "<br>By:艾庆国")
    @PostMapping("/updateStatus")
    public Result<Void> updateStatus(@RequestBody @Validated LineWarnConfigStatusUpdateParam param) {

        lineWarnConfigService.updateStatus(param);
        return Result.ok();
    }

    @Operation(summary = "删除配置", description = "<br>By:艾庆国")
    @PostMapping("/deleteConfig")
    public Result<Void> deleteConfig(@RequestBody @Validated LineWarnConfigDeleteUpdateParam param) {
        lineWarnConfigService.deleteConfig(param);
        return Result.ok();
    }

    @Operation(summary = "获取配置信息",description = "<br>By:艾庆国")
    @GetMapping("/getConfig")
    public Result<LineWarnConfigVO> getConfig(@NotNull(message = "id不能为空") @Validated Integer id) {
        return Result.ok(lineWarnConfigService.getConfig(id));
    }

    @Operation(summary = "分页搜索配置列表",description = "<br>By:艾庆国")
    @PostMapping("/pageConfig")
    public Result<PageData<LineWarnConfigVO>> pageConfig(@RequestBody @Validated PageLineWarnConfigParam param) {
        IPage<LineWarnConfigVO> page = lineWarnConfigService.pageConfig(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "预警类型下拉",description = "<br>By:艾庆国")
    @GetMapping("/listWarnType")
    public Result<List<LineWarnConfigVO.WarnTypeItem>> listWarnType() {
        return Result.ok(lineWarnConfigService.listWarnType());
    }

}
