package com.clx.performance.controller.pc.carrier;

import com.clx.performance.service.DictionaryService;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/dictionary")
@Validated
@Tag(name = "承运端-字典")
@AllArgsConstructor
public class DictionaryController {

    private final DictionaryService dictionaryService;


    @Operation(summary = "结算单列表（车主）",description = "<br>By:刘海泉")
    @GetMapping("/getOneByKey")
    public Result<String> getOneByKey(String key) {
        return Result.ok(dictionaryService.getOneByKey(key));
    }

}
