package com.clx.performance.vo.pc.owner.settle;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


@Getter
@Setter
@ToString
@NoArgsConstructor
public class PageOwnerSettlementOwnerDetailVO {

    @Schema(description="货主用户编号",example = "4174174")
    private Long ownerUserNo;

    @Schema(description="货主名称",example = "张三")
    private String ownerName;

    @Schema(description="结算单号",example = "41441")
    private String settlementNo;

    @Schema(description="结算子单号",example = "41441")
    private String settlementSubNo;

    @Schema(description="运单编号",example = "41441")
    private String childNo;


    @Schema(description="订单编号",example = "41441")
    private String orderNo;


    @Schema(description="货物名称",example = "货物名称")
    private String goodsName;

    @MoneyOutConvert
    @Schema(description="平台运费单价",example = "10.2")
    private BigDecimal freightPrice;

    @Schema(description="实际净重（吨）",example = "2.3")
    private BigDecimal weight;


    @Schema(description = "装车毛重（吨）", example = "1.23")
    private BigDecimal loadRough;
    @Schema(description = "装车皮重（吨）", example = "1.23")
    private BigDecimal loadTare;
    @Schema(description = "装车净重（吨）", example = "1.23")
    private BigDecimal loadNet;
    @Schema(description = "卸车毛重（吨）", example = "1.23")
    private BigDecimal unloadRough;
    @Schema(description = "卸车皮重（吨）", example = "1.23")
    private BigDecimal unloadTare;
    @Schema(description = "卸车净重（吨）", example = "1.23")
    private BigDecimal unloadNet;

    @MoneyOutConvert
    @Schema(description="应付运费",example = "2.52")
    private BigDecimal freight;

    @MoneyOutConvert
    @Schema(description="司机实收",example = "2.52")
    private BigDecimal driverFreight;

    @MoneyOutConvert
    @Schema(description="损耗单价",example = "1.2")
    private BigDecimal lossPrice;

    @Schema(description="货损吨数（吨）",example = "1.02")
    private BigDecimal lossWeight;

    @MoneyOutConvert
    @Schema(description="货损金额",example = "2.3")
    private BigDecimal lossFreight;

    @MoneyOutConvert
    @Schema(description="预付运费金额",example = "1.2")
    private BigDecimal prepayFreight;

    @MoneyOutConvert
    @Schema(description="结算金额",example = "1.2")
    private BigDecimal settlementFreight;

    @MoneyOutConvert
    @Schema(description="借款抵扣金额",example = "1.2")
    private BigDecimal loanFreight;

    @MoneyOutConvert
    @Schema(description="开票金额",example = "2.1")
    private BigDecimal invoiceFreight;

    @Schema(description = "开票标识：1网运单 2普通单",example = "2")
    private Integer invoiceType;

    @Schema(description="开票标识：1网运单 2普通单",example = "普通单")
    private String invoiceTypeMsg;

    @MoneyOutConvert
    @Schema(description="开票服务费",example = "2.1")
    private BigDecimal invoiceServiceFee;
    @Schema(description="开票费率%",example = "12.34")
    private BigDecimal invoiceServiceFeeRate;

    @Schema(description="尾款状态 0-否,1-是,2-无需支付",example = "无需支付")
    private String finalPaymentStatusMsg;

    @Schema(description="开票状态 0-否,1-是",example = "是")
    private String invoiceStatusMsg;

    @Schema(description="结算方式  1装车净重 2卸车净重 3卸车净重（减货损）",example = "1")
    private Integer settlementWay;

    @Schema(description="结算方式")
    private String settlementWayMsg;

    @Schema(description="开票公司id",example = "1")
    private Integer invoicingCompanyId;  //开票公司id
    @Schema(description="开票公司简称",example = "1")
    private String invoicingCompanyShorterName; //开票公司简称
    @Schema(description="开票公司统一社会信用代码",example = "1")
    private String invoicingCompanyGroupCode;  //开票公司统一社会信用代码
    @Schema(description="是否上报 0-否;1-是",example = "1")
    private Integer reportFlag;  //是否上报 0-否;1-是

    @Schema(description = "开票时间")
    private String invoiceTime;

    @Schema(description = "拆单备注")
    private String separateRemark;

    @Schema(description="创建时间",example = "2013-01-01 00:00:00")
    private String createTime;

    @Schema(description="备注")
    private String remark;

    @Schema(description="磅单审核通过时间")
    private String poundAuditTime;
}