package com.clx.performance.vo.pc;

import com.clx.performance.enums.OrderEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @ClassName PagePendingFreightVO
 * @Description
 * @Author kavin
 * @Date 2024/10/21 9:51
 * @Version 1.0
 */

@Getter
@Setter
public class PagePendingFreightVO {


    private Integer id;

    
    @Schema(description="订单编号")
    private String orderNo;

    
    @Schema(description="订单状态")
    private Integer orderStatus;


    @Schema(description="货源地")
    private String sendAddressShorter;

    
    @Schema(description="煤源位置")
    private String sendAddress;






    
    @Schema(description="物流经理")
    private String seniorLogisticsManagerName;

    
    @Schema(description="货物名称id")
    private Integer goodsNameId;

    
    @Schema(description="货物名称")
    private String goodsName;



    
    @Schema(description="热值名称")
    private String goodsModel;

    
    @Schema(description="是否C类煤源  0 否  1 是")
    private Integer sendOverStandard;

    public String sendOverStandardMsg;

    public String getSendOverStandardMsg(){
        return OrderEnum.OverWeight.getNameByCode(sendOverStandard);
    }

    
    @Schema(description="任务吨数")
    private BigDecimal taskWeight;

    
    @Schema(description="接单率")
    private BigDecimal orderedRate;

    
    @Schema(description="装车率")
    private BigDecimal loadTruckRate;

    
    @Schema(description="重车运距(公里)")
    private BigDecimal orderDistance;

    
    @Schema(description="煤源地开支")
    private String sendAddressExpenses;

    
    @Schema(description="历史运费")
    @MoneyOutConvert
    private BigDecimal historyFreight;

    
    @Schema(description="历史平均运费")
    @MoneyOutConvert
    private BigDecimal historyAvgFreight;

    
    @Schema(description="测算运费")
    @MoneyOutConvert
    private BigDecimal predictionFreightPrice;

    
    @Schema(description="物流运费")
    @MoneyOutConvert
    private BigDecimal logisticsFreight;

    
    @Schema(description="创建时间")
    private String createTime;




}
