package com.clx.performance.param.pc.payment;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import lombok.experimental.Accessors;
import jakarta.validation.constraints.NotBlank;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Accessors(chain = true)
public class PayParam {
	@NotBlank(message = "支付人不能为空")
	@Schema(description = "支付来源", example = "2234")
	Integer from;
	@NotBlank(message = "支付密码不能为空")
	@Schema(description = "支付方密码", example = "2356")
	String pwd;
	@NotBlank(message = "收款钱包不能为空")
	@Schema(description = "支付去向", example = "2234")
	Integer to;
	@NotBlank(message = "金额不能为空")
	@Schema(description = "金额", example = "2356")
	Integer figure;
	@NotBlank(message = "交易单号不能为空")
	@Schema(description = "交易单号", example = "2356")
	String tradeNo;
	@NotBlank(message = "交易单id不能为空")
	@Schema(description = "交易单id", example = "23")
	String tradeId;
	@NotBlank(message = "交易备注不能为空")
	@Schema(description = "交易备注", example = "23")
	String remark;


}
