package com.clx.performance.param.pc.owner;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

/**
 * @ClassName PageOwnerSettlementParam
 * @Description
 * @Author kavin
 * @Date 2023/10/17 15:46
 * @Version 1.0
 */
@Getter
@Setter
public class PageOwnerSettlementParam extends PageParam {

    @Schema(description = "结算单编号", example = "JS415")
    private String settlementNo;

    @Schema(description="订单编号",example = "201457878")
    private String orderNo;

    @Schema(description = "订单/结算单号 复合搜索", example = "JS415")
    private String searchNo;

    @Schema(description="状态 10:待锁定  20:待对账  30:待货主确认 40:待货主付款 50:待平台确认付款 60:待平台付款 70:待货主确认付款 80:待邮寄发票 90:已完结",example = "10")
    private Integer status;

    @Schema(description = "开票标识：1网运单 2普通单", example = "1")
    private Integer invoiceType;

    @Schema(description = "开始时间", example = "1")
    private String beginTime;

    @Schema(description = "结束时间", example = "1")
    private String endTime;
}
