package com.clx.performance.param.pc.breakcontract.carrier;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Setter
@Getter
@ToString
@NoArgsConstructor
public class PageCarrierBreakContractSettlementDriverParam extends PageParam {


    @Schema(description="运单编号",example = "201457878")
    private String childNo;

    @Schema(description="结算单号",example = "201457878")
    private String settlementNo;

    @Schema(description="车主编号",example = "201457878")
    private Long truckOwnUserNo;

    @Schema(description="车主名称")
    private String truckOwnName;

    @Schema(description="结算状态 1待结算;2已结算")
    private Integer settleStatus;

    @Schema(description = "违约方类型：1平台 2货主 3车主", example = "1")
    private Integer breakContractPartyType;

    @Schema(description="开始时间",example = "2012-01-01 00:00:00")
    private String beginTime;

    @Schema(description="结束时间",example = "2012-01-01 00:00:00")
    private String endTime;

}
