package com.clx.performance.param.feign.transport;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

@Setter
@Getter
@ToString
@NoArgsConstructor
public class ThirdOrderInfoDTO {

    @Schema(description = "货单编码", required = true)
    private String orderNo;
    @Schema(description = "货物名称", required = true)
    private String goodsName;

    @Schema(description = "发货单位")
    private String sendCompany;
    @Schema(description = "发货所在省份", required = true)
    @NotBlank(message = "发货所在省份不能为空")
    private String sendProvince;
    @Schema(description = "发货所在城市", required = true)
    @NotBlank(message = "发货所在城市不能为空")
    private String sendCity;
    @Schema(description = "发货所在区县", required = true)
    @NotBlank(message = "发货所在区县不能为空")
    private String sendCounty;
    @Schema(description = "发货所在乡镇", required = true)
//    @NotBlank(message = "发货所在乡镇不能为空")
    private String sendTown;
    @Schema(description = "发货详细地址", required = true)
    @NotBlank(message = "发货详细地址不能为空")
    private String sendAddress;
    @Schema(description = "发货联系人", required = true)
    @NotBlank(message = "发货联系人不能为空")
    private String sendName;
    @Schema(description = "发货联系人手机号", required = true)
    @NotBlank(message = "发货联系人手机号不能为空")
    private String sendMobile;
    @Schema(description = "发货地址经度", required = true)
    @NotBlank(message = "发货地址经度不能为空")
    private String loadLongitude;
    @Schema(description = "发货地址纬度", required = true)
    @NotBlank(message = "发货地址纬度不能为空")
    private String loadLatitude;

    @Schema(description = "收货单位")
    private String receiveCompany;
    @Schema(description = "收货人所在省", required = true)
    @NotBlank(message = "收货人所在省不能为空")
    private String receiveProvince;
    @Schema(description = "收货人所在城市", required = true)
    @NotBlank(message = "收货人所在城市不能为空")
    private String receiveCity;
    @Schema(description = "收货人所在区县", required = true)
    @NotBlank(message = "收货人所在区县不能为空")
    private String receiveCounty;
    @Schema(description = "收货人所在乡镇", required = true)
//    @NotBlank(message = "收货人所在乡镇不能为空")
    private String receiveTown;
    @Schema(description = "收货详细地址", required = true)
    @NotBlank(message = "收货详细地址不能为空")
    private String receiveAddress;
    @Schema(description = "收货联系人", required = true)
    @NotBlank(message = "收货联系人不能为空")
    private String receiveName;
    @Schema(description = "收货联系人手机号", required = true)
    @NotBlank(message = "收货联系人手机号不能为空")
    private String receiveMobile;
    @Schema(description = "收货地址经度", required = true)
    @NotBlank(message = "收货地址经度不能为空")
    private String unloadLongitude;
    @Schema(description = "收货地址纬度", required = true)
    @NotBlank(message = "收货地址纬度不能为空")
    private String unloadLatitude;

    @Schema(description = "货物单价（单位：分）", required = true)
    @NotNull(message = "货物单价不能为空")
    private Integer goodsPrice;
    @Schema(description = "运费单价（单位：分）", required = true)
    @NotNull(message = "运费单价不能为空")
    private Integer transPrice;
    @Schema(description = "货物总重量(吨)", required = true)
    @NotNull(message = "货物总重量不能为空")
    private BigDecimal goodsAmount;
    @Schema(description = "最晚装货时间", required = true)
    @NotBlank(message = "最晚装货时间不能为空")
    private String extractTime;
    @Schema(description = "司机最晚到达时间", required = true)
    @NotBlank(message = "司机最晚到达时间不能为空")
    private String arriveTime;

}
