package com.clx.performance.param.app.owner;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @ClassName PageOwnerOrderChildListParam
 * @Description
 * @Author kavin
 * @Date 2023/12/22 15:02
 * @Version 1.0
 */

@Getter
@Setter
public class PageOwnerOrderChildListParam extends PageParam {

    @Schema(description="运单编号/车牌号/订单编号")
    private String searchNo;

    @Schema(description="运单状态集合")
    private List<Integer> status;
    @Schema(description="开始时间")
    private String beginTime;
    @Schema(description="结束时间")
    private String endTime;

    @Schema(description="货主编码")
    @JsonIgnore
    private Long ownerUserNo;
}
