package com.clx.performance.param.app;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class OrderChildUnloadParam extends PositionParam {

    @Schema(description = "运单编号", example = "100000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @Schema(description = "卸货毛重（单位吨）", example = "2.46")
    private BigDecimal unloadRough;

    @Schema(description = "卸货皮重（单位吨）", example = "1.23")
    private BigDecimal unloadTare;

    @Schema(description = "卸货净重（单位吨）", example = "1.23")
    private BigDecimal unloadNet;

    @Schema(description = "磅单图片列表")
    @NotEmpty(message = "请上传磅单照片")
    private List<String> unloadImageList;

    @Schema(description = "交货时间")
    private String unloadTime;

}
