package com.clx.performance.enums.export;

import lombok.AllArgsConstructor;
import lombok.Getter;


@Getter
@AllArgsConstructor
public enum FunctionCodeEnum {

    PERFORMANCE_PROGRESS("performance_progress", "履约进度表", 0),

    ;


    private final String code;

    private final String name;

    private final Integer needCoalBlendingBaseFlag;

    public static Integer getByCode(String functionCode) {
        for (FunctionCodeEnum value : values()) {
            if (value.getCode().equals(functionCode)) {
                return value.getNeedCoalBlendingBaseFlag();
            }
        }
        return null;
    }
}
