package com.clx.performance.model.loan;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_payment")
public class OwnerPayment implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("owner_user_no")
    @Schema(description="货主编码")
    private Long ownerUserNo;

    @TableField("owner_user_name")
    @Schema(description="货主名称")
    private String ownerUserName;

    @TableField("mobile")
    @Schema(description="联系电话")
    private String mobile;

    @TableField("running_water_open_no")
    @Schema(description="交易流水号（第三方）")
    private String runningWaterOpenNo;

    @TableField("merchant_running_water_no")
    @Schema(description="商户流水")
    private String merchantRunningWaterNo;

    @TableField("payment_no")
    @Schema(description="付款单号")
    private Long paymentNo;

    @TableField("repayment_no")
    @Schema(description="还款单号")
    private Long repaymentNo;

    @TableField("payment_balance")
    @Schema(description="付款金额")
    private BigDecimal paymentBalance;

    @TableField("payment")
    @Schema(description="付款方")
    private String payment;

    @TableField("payment_account")
    @Schema(description="付款账户")
    private String paymentAccount;

    @TableField("payee")
    @Schema(description="收款方")
    private String payee;

    @TableField("payee_account")
    @Schema(description="收款账户")
    private String payeeAccount;

    @TableField("payee_bank_code")
    @Schema(description="收款银行行号")
    private String payeeBankCode;

    @TableField("status")
    @Schema(description="10 待付款 40 付款中 50 付款成功 60 付款失败")
    private Integer status;

    @TableField("pay_channel")
    @Schema(description="默认财资")
    private Integer payChannel;

    @TableField("operate_time")
    @Schema(description="操作时间")
    private LocalDateTime operateTime;

    @TableField("operate_by")
    @Schema(description="操作人")
    private String operateBy;

    @TableField("create_by")
    @Schema(description="创建人")
    private String createBy;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
