package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

@Getter
@Setter
@Accessors(chain = true)
@TableName("third_part_request_log")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ThirdPartRequestLog implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    @Schema(description = "ID")
    private Integer id;

    @Schema(description = "请求id")
    private String requestId;

    @Schema(description = "应用编号")
    private Long appNo;

    @Schema(description = "请求类型: 1-发送请求；2-接收请求")
    private Integer requestType;

    @Schema(description = "操作类型")
    private String action;

    @Schema(description = "请求地址")
    private String url;

    @Schema(description = "请求参数（JSON格式）")
    private String requestContent;

    @Schema(description = "返回数据（JSON格式）")
    private String responseContent;

    @Schema(description = "返回状态码")
    private Integer statusCode;

    @Schema(description = "状态: 0-请求中,1-成功,2-失败")
    private Integer status;

    @Schema(description = "重试次数")
    private Integer retryTimes;

    @Schema(description = "其他字段")
    private String otherFields;

    @Schema(description = "创建时间")
    private LocalDateTime createTime;

    @Schema(description = "修改时间")
    private LocalDateTime modifiedTime;

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}
