package com.clx.performance.job;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.clx.performance.service.LastTruckService;
import com.msl.common.job.JobLog;
import com.msl.common.result.Result;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@AllArgsConstructor
public class SyncLastTruckJob {


    private final LastTruckService lastTruckService;


    /**
     * 手动触发最后一车推送第三方平台
     */
    @XxlJob("handExecSyncSmbLastTruck")
    public void handExecSyncSmbLastTruck() {
        try {

            String jobParam= XxlJobHelper.getJobParam();
            JSONObject jsonObject = JSON.parseObject(jobParam);
            String orderNo = jsonObject.getString("orderNo");
            String childNo = jsonObject.getString("childNo");
            log.info("开始手动执行同步最后一车，订单号:{}.运单号:{}",orderNo,childNo);
            Result<?> result = lastTruckService.handExecSyncSmbLastTruck(orderNo,childNo);
            log.info("结束手动执行同步最后一车，订单号:{}.运单号:{}，响应结果:{}",orderNo,childNo,result);
        } catch (Exception e) {
            log.warn("同步最后一车到第三方平台发生异常，异常原因:{}", ExceptionUtils.getStackTrace(e));
            JobLog.error("同步最后一车到第三方平台发生异常，异常原因=====================", e);
        }
    }


}
