package com.clx.performance.extranal.user.impl;

import com.clx.order.feign.AddressFeign;
import com.clx.order.vo.feign.FeignAddressVO;
import com.clx.order.vo.feign.SystemAddressVO;
import com.clx.performance.extranal.user.AddressService;
import com.msl.common.base.Optional;
import com.msl.common.result.Result;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
@Slf4j
@AllArgsConstructor
public class AddressServiceImpl implements AddressService {
    private final AddressFeign addressFeign;

    @Override
    public Optional<FeignAddressVO> getSendAndReceiveAddress(Integer sendAddressId, Integer receiveAddressId) {
        return Optional.ofNullable(addressFeign.getSendAndReceiveAddress(sendAddressId, receiveAddressId))
                .filter(Result::succeed)
                .map(Result::getData);
    }

    @Override
    public Optional<SystemAddressVO> getSystemAddress(Integer addressId) {
        return Optional.ofNullable(addressFeign.getSystemAddress(addressId))
                .filter(Result::succeed)
                .map(Result::getData);
    }

    @Override
    public String generateAddressDetail(String ... args) {
        StringBuilder sb = new StringBuilder();
        String detail = args[args.length-1];
        for (String arg : args) {
            if(StringUtils.isNotBlank(arg) && !detail.contains(arg)){
                sb.append(arg);
            }
        }
        sb.append(detail);
        return sb.toString();
    }

}
