package com.clx.performance.esplus.model;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.dromara.easyes.annotation.IndexField;
import org.dromara.easyes.annotation.IndexId;
import org.dromara.easyes.annotation.IndexName;
import org.dromara.easyes.annotation.rely.FieldType;
import org.dromara.easyes.annotation.rely.IdType;

import java.math.BigDecimal;

@Data
@IndexName("clx_trace_driver_trace_index1")
public class DriverTraceESPlus {

    @IndexId(type= IdType.UUID)
    private String id;

    @Schema(description="用户编号")
    private Long userNo;

    @Schema(description="1-正常上传，2-离线上传")
    private Integer dataType;

    @IndexField(fieldType = FieldType.GEO_POINT)
    private BigDecimal[] location;  //位置

    @Schema(description="速度")
    private BigDecimal speed;

    @IndexField(fieldType = FieldType.DATE)
    private String positionTime;

    @IndexField(fieldType = FieldType.DATE)
    private String createTime;

    @IndexField(fieldType = FieldType.DATE)
    private String modifiedTime;

}