package com.clx.performance.dto.gd;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.util.List;

/**
 * @Author: aiqingguo
 * @Description: 收发货地址线路
 * @Date: 2023/2/28 11:02
 * @Version: 1.0
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@Schema(description = "高德线路规划")
public class GdRouteDTO {

    @Schema(description = "距离(m)", example = "1")
    private Integer distance;
    @Schema(description = "时间s", example = "1")
    private Integer duration;

    @Schema(description = "线路轨迹")
    private List<GdPosDTO> posList;

}
